const fs = require('fs');
const path = require('path');

// Fonction pour rechercher des motifs spécifiques qui pourraient causer l'erreur
function findExactError(filePath) {
  if (!fs.existsSync(filePath)) {
    console.error(`Fichier non trouvé: ${filePath}`);
    return;
  }
  
  try {
    const content = fs.readFileSync(filePath, 'utf8');
    const lines = content.split('\n');
    
    console.log(`Analyse détaillée de: ${filePath}`);
    
    // Rechercher des motifs spécifiques qui pourraient causer l'erreur "unexpected identifier 'directe', expecting ')'"
    for (let i = 0; i < lines.length; i++) {
      const line = lines[i];
      
      // Rechercher des parenthèses non équilibrées
      let openParens = 0;
      for (let j = 0; j < line.length; j++) {
        if (line[j] === '(') openParens++;
        if (line[j] === ')') openParens--;
      }
      
      // Si la ligne contient "directe" et a des parenthèses non équilibrées
      if (line.includes('directe') && openParens !== 0) {
        console.log(`⚠️ Ligne ${i+1}: Parenthèses non équilibrées et contient "directe"`);
        console.log(`   ${line}`);
      }
      
      // Rechercher des motifs spécifiques qui pourraient causer l'erreur
      if (line.match(/\([^"']*"directe"[^"']*\)/)) {
        console.log(`⚠️ Ligne ${i+1}: "directe" utilisé comme identifiant dans des parenthèses`);
        console.log(`   ${line}`);
      }
      
      // Rechercher des cas où "directe" est utilisé comme identifiant après une virgule
      if (line.match(/,[^"']*"directe"[^"']*[,\)]/)) {
        console.log(`⚠️ Ligne ${i+1}: "directe" utilisé comme identifiant après une virgule`);
        console.log(`   ${line}`);
      }
      
      // Rechercher des cas où "directe" est utilisé dans une fonction
      if (line.match(/function[^(]*\([^)]*"directe"[^)]*\)/)) {
        console.log(`⚠️ Ligne ${i+1}: "directe" utilisé comme paramètre de fonction`);
        console.log(`   ${line}`);
      }
    }
    
  } catch (err) {
    console.error(`Erreur lors de l'analyse de ${filePath}: ${err}`);
  }
}

// Analyser les fichiers principaux
console.log("Recherche de l'erreur exacte...");
findExactError('/home/project/js/geoloc.js');
findExactError('/home/project/tmpl/assets/main.js');
console.log("Analyse terminée.");
